from fleming.common.firmware_util import *


signals = {
    'flash'     : (1 << 23),
    'alpha'     : (1 << 22),
    'htsalpha'  : (1 << 21),
    'ingate2'   : (1 << 17),
    'ingate1'   : (1 << 16),
    'hvgate2'   : (1 << 13),
    'hvgate1'   : (1 << 12),
    'hvon3'     : (1 << 10),
    'hvon2'     : (1 <<  9),
    'hvon1'     : (1 <<  8),
    'rstaux'    : (1 <<  6),
    'rstabs'    : (1 <<  5),
    'rstref'    : (1 <<  4),
    'rstpmt2'   : (1 <<  1),
    'rstpmt1'   : (1 <<  0),
}


async def trigger_n_times(frequency, time, flash_pwr=0.0, high_pwr=0):

    meas = get_measurement_endpoint()
    
    iterations = frequency*time
    duration_us = (((1/frequency)/2)*1000000)

    # Cancel if HighPower is set and Freqency above 500
    if frequency > 500 and high_pwr == 1:
        raise Exception(f"No HighPwr above 500Hz")
    
    node = get_node_endpoint('eef')
    
    # Set the Flash_Pwr if given
    if flash_pwr is not None:
        await node.SetAnalogOutput(12, flash_pwr)
        await asyncio.sleep(0.1)
    
    # Set HighPower 
    await node.SetDigitalOutput(9,high_pwr)
    await asyncio.sleep(0.1)


    ontime = int(100 * duration_us)
    offtime = int(1 / frequency * 1e8 - ontime)
    loop_a = int(iterations / 65536)
    loop_b = int(iterations % 65536)
    sequence = []
    if loop_a > 0:
        sequence.extend([
            0x07000000 | (loop_a - 1),      # Loop A Multiple of 2^16
            0x07000000 | (65536 - 1),       # Loop Inner
            0x7C000000 | (ontime - 1),      # Wait for offtime timer then start ontime timer
            0x02000000 | signals['flash'],  # Set Flash_Trg high
            0x7C000000 | (offtime - 1),     # Wait for ontime timer then start offtime timer
            0x03000000 | signals['flash'],  # Set Flash_Trg low
            0x05000000,                     # LoopEnd
            0x05000000,                     # LoopEnd
        ])
    if loop_b > 0:
        sequence.extend([
            0x07000000 | (loop_b - 1),      # Loop B Remainder
            0x7C000000 | (ontime - 1),      # Wait for offtime timer then start ontime timer
            0x02000000 | signals['flash'],  # Set Flash_Trg high
            0x7C000000 | (offtime - 1),     # Wait for ontime timer then start offtime timer
            0x03000000 | signals['flash'],  # Set Flash_Trg low
            0x05000000,                     # LoopEnd
        ])
    sequence.extend([
        0x00000000,                     # Stop
    ])
    await meas.WriteSequence(0, len(sequence), sequence, timeout=5)
    await meas.StartSequence(0, timeout=1)

